/******
This program reads in a text file of CORRECTLY FORMATTED FITS keywords
(i.e., all the "=" and "/" characters in the right columns), and writes
out a FITS header as a stream of 2880 bytes.

Command syntax:
        >TXT2FITS
                  prompts for the name of the text file to convert into
                  a FITS header.

        >TXT2FITS AAA.TXT
                  converts the text file AAA.TXT into the FITS header
                  file AAA.HDR.

        >TXT2fits AAA.TXT BBB.TMP
                  converts the text file AAA.TXT into the FITS header
                  file BBB.TMP.

Compile this program under the Tiny model, and convert it to a .COM file
using EXE2BIN.

Version 1.0 written 4/89 by A. Warnock, ST Systems Corp.
Uses Turbo C from Borland Int'l.
*****/

#include <stdio.h>
#include <string.h>

#define NULL 0
#define TRUE 'T'
#define FALSE 'F'
#define FITS_SIZE 2880
#define TEXT_SIZE 80

/* Global declarations */
   char    inbfr[83],                          /* input FITS record */
           outbfr[2881];                       /* output text buffer */

main(int argc, char *argv[])
{
   FILE    *infile,                            /* Input file */
           *outfile;                           /* Output file */
   char    linebfr[64],                        /* scratch buffer */
           _end[] = "END",                     /* end of header string */
           *ptr;
   int     i,                                  /* loop counter */
           b_len,                              /* length of keyword */
           eoh;                                /* end of header flag */

/* Get the name of the input text file */
   if ( argc > 1 )
   {
       strcpy( linebfr, argv[1]) ;
   }
   else
   {
       printf( "Enter the input text file name: ");
       gets(linebfr);
       if ( !strlen(linebfr) )
       {
           printf( "You must enter a file name!\n" );
           exit();
       }
   }

/* Open the text file */
   infile = fopen( linebfr, "r" );
   if ( !infile )
   {
       printf( "Can't open input file!\n" );
       exit();
   }

/* Get the name of the output text file */
   if (argc > 2)
   {
       strcpy( linebfr, argv[2]);
   }
   else
   {
       ptr = strtok( linebfr, ".");
       if (ptr != NULL)
       {
           strcat( ptr, ".HDR");
           strcpy( linebfr, ptr);
       }
       else
       {
           printf( "Enter the FITS header file name: ");
           gets(linebfr);
           if ( !strlen(linebfr) )
           {
               printf( "You must enter a file name!\n" );
               exit();
           }
       }
   }

/* Open the header file */
   outfile = fopen( linebfr, "w" );
   if ( !outfile )
   {
       printf( "Can't open output file!\n" );
       exit();
   }


/* Initialize some stuff first */
   eoh = FALSE ;

/* Start reading the text file.  This loop counts keywords, filling
   the output buffer (80 bytes at a time) until the keyword END is
   found.  If 36 keywords are read without finding END, another 2880
   byte record is written, and another started.
*/
   while (eoh == FALSE)
   {
       memset( outbfr, 32, FITS_SIZE) ;                  /* blank the buffer */
       for (i=0; i<36; i++)                              /* Count keywords */
       {
           fgets( inbfr, TEXT_SIZE+2, infile) ;          /* leave room for EOL */
           b_len = strlen( inbfr ) ;
           strncpy( &outbfr[TEXT_SIZE*i], inbfr, b_len-1);   /* stash in output */
           if (strncmp( inbfr, _end, 3) == 0)            /* Was keyword=END? */
           {
               eoh = TRUE ;                              /* set flag if yes */
               break ;                                   /* and quit */
           }
       }
       fputs( outbfr, outfile);                          /* flush the buffer */
   }
}
