/******
This program reads in FITS headers as a stream of 2880 bytes, and writes
out each keyword as a separate 80-byte record into a text file.

Command syntax:
        >FITS2TXT
                  prompts for the name of the FITS header file to
                  convert.

        >FITS2TXT AAA.HDR
                  converts the FITS header file AAA.HDR into the text
                  file AAA.TXT.

        >FITS2TXT AAA.HDR BBB.TMP
                  converts the FITS header file AAA.HDR into the text
                  file BBB.TMP.

Compile this program under the Tiny model, and convert it to a .COM file
using EXE2BIN.

Version 1.0 written 4/89 by A. Warnock, ST Systems Corp.
Uses Turbo C from Borland Int'l.
*****/

#include <stdio.h>
#include <string.h>

#define NULL 0
#define TRUE 'T'
#define FALSE 'F'
#define FITS_SIZE 2880
#define TEXT_SIZE 80

extern char   *ClearEnd( char * );

/* Global declarations */
    char   inbfr[2881],                        /* input FITS record */
           outbfr[81];                         /* output text buffer */

main(int argc, char *argv[])
{
   FILE    *infile,                            /* Input file */
           *outfile;                           /* Output file */
   char    linebfr[64],                        /* scratch buffer */
           _end[] = "END",                     /* end of header string */
           _xtension[] = "XTENSION",           /* FITS extension string */
           *nextrec,
           *ptr;
   int     i,                                  /* loop counter */
           eoh;                                /* end of header flag */

/* Get the name of the input table file */
   if ( argc > 1 )
   {
       strcpy( linebfr, argv[1]) ;
   }
   else
   {
       printf( "Enter the FITS header file name: ");
       gets(linebfr);
       if ( !strlen(linebfr) )
       {
           printf( "You must enter a file name!\n" );
           exit();
       }
   }

/* Open the header file */
   infile = fopen( linebfr, "r" );
   if ( !infile )
   {
       printf( "Can't open input file!\n" );
       exit();
   }

/* Get the name of the output text file */
   if (argc > 2)
   {
       strcpy( linebfr, argv[2]);
   }
   else
   {
       ptr = strtok( linebfr, ".");
       if (ptr != NULL)
       {
           strcat( ptr, ".TXT");
           strcpy( linebfr, ptr);
       }
       else
       {
           printf( "Enter the output text file name: ");
           gets(linebfr);
           if ( !strlen(linebfr) )
           {
               printf( "You must enter a file name!\n" );
               exit();
           }
       }
   }

/* Open the text file */
   outfile = fopen( linebfr, "w" );
   if ( !outfile )
   {
       printf( "Can't open output file!\n" );
       exit();
   }

/* Initialize some stuff first */
   outbfr[80] = NULL ;
   eoh = FALSE ;

/* Start reading the FITS header.  This loop counts keywords, writing
   lines out until the input buffer is empty (after 36 keywords) or
   until the keyword END is found.  If 36 keywords are written without
   finding END, another 2880 byte record is read from the input file.
*/
   while ( (fgets( inbfr, FITS_SIZE+1, infile) != NULL) && (eoh == FALSE) )
   {
       for (i=0; i<36; i++)                            /* Count keywords */
       {
           strncpy( outbfr, &inbfr[TEXT_SIZE*i], TEXT_SIZE);   /* 1 line of output */
           nextrec = ClearEnd( outbfr );               /* Drop trailing blanks, */
           strcat( outbfr, "\n" );                     /* add <CR><LF> */
           fputs( outbfr, outfile);                    /* and write it out */
           if (strncmp( outbfr, _end, 3) == 0)         /* Was the keyword END? */
           {
               eoh = TRUE ;                            /* set flag if yes */
               break ;                                 /* and quit */
           }
       }
   }

/* Now, go on to the extension header, if there is one */
   close( outfile );
   eoh = FALSE ;

/* Start reading the extension FITS header.  This loop counts keywords,
   writing lines out until the input buffer is empty (after 36 keywords)
   or until the keyword END is found.  If 36 keywords are written
   without finding END, another 2880 byte record is read from the input
   file.
*/
   if (strncmp( inbfr, _xtension, 8) == 0)
   {
    /* Get the name of the output text file */
       if (argc > 2)
       {
           strcpy( linebfr, argv[2]);
       }
       else
       {
           ptr = strtok( linebfr, ".");
           if (ptr != NULL)
           {
               strcat( ptr, ".TX1");
               strcpy( linebfr, ptr);
           }
           else
           {
               printf( "Enter the output text file name: ");
               gets(linebfr);
               if ( !strlen(linebfr) )
               {
                   printf( "You must enter a file name!\n" );
                   exit();
               }
           }
       }

    /* Open the text file */
       outfile = fopen( linebfr, "w" );
       if ( !outfile )
       {
           printf( "Can't open output file!\n" );
           exit();
       }
       do
       {
           for (i=0; i<36; i++)                        /* Count keywords */
           {
               strncpy( outbfr, &inbfr[TEXT_SIZE*i], TEXT_SIZE);   /* 1 line of output */
               nextrec = ClearEnd( outbfr );           /* Drop trailing blanks, */
               strcat( outbfr, "\n" );                 /* add <CR><LF> */
               fputs( outbfr, outfile);                /* and write it out */
               if (strncmp( outbfr, _end, 3) == 0)     /* Was is END? */
               {
                   eoh = TRUE ;                        /* set flag if yes */
                   break ;                             /* and quit */
               }
           }
       } while ( (fgets( inbfr, FITS_SIZE+1, infile) != NULL) && (eoh == FALSE) );
    }
   close( infile );
   close( outfile );
   return( 1 );
}
