/**************************************************************
*
*   FITSXTND.C - extends a data file out to a multiple of 2880 bytes
*                to make it FITS compatible
*
*   Written 1/91 by A. Warnock, ST Systems Corp.
*
***************************************************************/

#include <stdio.h>
#include <string.h>
#include <dir.h>

FILE   *do_outfile( char * filename)
/***  do_outfile makes a new file name from the one contained in linebfr
      by putting a new filename extension on the string, then creates it
      as a new file.  It prompts for a filename if no "." is found in
      the name passed down.  It exits to DOS if the file couldn't be
      created.

   Parameter    Type    In/out   Description
   filename    char ptr   in     The buffer containing the old file name

***/
{
   FILE    *outfile;                   /* Pointer to output file */
   char    *ptr;                       /* scratch pointer */
   char    linebfr[80];                /* scratch filename buffer */

/**************************************************************************

    Process the OUTPUT file name and open the file

*/

        strcpy( linebfr, filename);
        ptr = strtok( linebfr, ".");
        if (ptr != NULL)
        {
            strcat( ptr, ".OUT");
            strcpy( linebfr, ptr);
        }
        else
        {
           printf( "Enter the name for the output file: ");
           gets(linebfr);
           if ( !strlen(linebfr) )
           {
               printf( "You must enter a file name!\n" );
               exit();
           }
        }


/* Open the output FITS file */
   outfile = fopen( linebfr, "wb" );
   if ( !outfile )
   {
       printf( "Can't open output file!\n" );
       exit();
   }
   return(outfile);
}


int main(int argc, char * argv[])
{
    FILE *in, *out;
    char inbuf[2880], outbuf[2880];
    char line_buffer[80];
    int  n_read, done;
    struct ffblk   file_info;

/*  Get the FITS header file name */
    if ( argc > 1 )
    {
       strcpy( line_buffer, argv[1]) ;
    }
    else
    {
       printf( "Enter the name of the input data file: ");
       gets(line_buffer);
       if ( !strlen(line_buffer) )
       {
           printf( "You must enter a file name!\n" );
           exit(1);
       }
    }

/*  Find the name of the matching header file - may be the only one */
    done = findfirst( line_buffer, &file_info, 0);
    while( !done )
    {

    /* Now, open the output file with the extension .LBL */
       in  = fopen( file_info.ff_name, "rb");
       out = do_outfile( file_info.ff_name );
       printf( "Extending %s to FITS length.  ", file_info.ff_name);
       while (!feof(in))
       {
           memset( outbuf, 0, 2880);
           n_read = fread( inbuf, 1, 2880, in);
           memcpy( outbuf, inbuf, n_read);
           fwrite( outbuf, 2880, 1, out);
       }
       printf( "Done.\n" );
       fclose( in );
       fclose( out );

/*  Look for another matching file name */
       done = findnext( &file_info );
    }
    return( 0 );
}
